######################################################################################
# This code (Version 2.1) is provided for educational purposes.
# If you use, adapt, or redistribute this code, please cite the source as follows:
# Dun-Yen Kang at National Taiwan University, http://www.mmlab-ntu.tw , September 2024 
######################################################################################

import numpy as np
from scipy.integrate import quad
import tkinter as tk
from tkinter import messagebox

# Define the function to compute H_IG and S_IG
def compute():
    try:
        # Get input values from the user
        A = float(entry_A.get())
        B = float(entry_B.get())
        C = float(entry_C.get())
        D = float(entry_D.get())
        T_ref = float(entry_T_ref.get())
        P_ref = float(entry_P_ref.get())
        T_target = float(entry_T_target.get())
        P_target = float(entry_P_target.get())

        # Define the integrands as functions
        def polynomial_1(T):
            return A + B*T + C*T**2 + D*T**3

        def polynomial_2(T):
            return A/T + B + C*T + D*T**2

        # Perform numerical integration using quad
        H_IG, _ = quad(polynomial_1, T_ref, T_target)
        S_IG, _ = quad(polynomial_2, T_ref, T_target)
        S_IG -= 8.314 * np.log(P_target / P_ref)  # Adjust S_IG for the pressure change

        # Clear the text boxes and insert only the numerical values
        result_H_IG_box.delete("1.0", tk.END)
        result_H_IG_box.insert(tk.END, f'{H_IG:.2f}')
        
        result_S_IG_box.delete("1.0", tk.END)
        result_S_IG_box.insert(tk.END, f'{S_IG:.2f}')
        
    except ValueError:
        messagebox.showerror("Input Error", "Please enter valid numbers.")

# Function to close the application
def quit_app():
    root.quit()  # Closes the mainloop
    root.destroy()  # Destroys the window

# Create the main window
root = tk.Tk()
root.title("H and S of Ideal Gas")

# Display the equation Cp = A + B*T + C*T^2 + D*T^3 at the top
tk.Label(root, text="Cp = A + B*T + C*T^2 + D*T^3 [J/mol/K]").grid(row=0, column=0, columnspan=2, pady=10)

# Display the suggested values for oxygen
tk.Label(root, text="Suggested values for the reference state:").grid(row=1, column=0, columnspan=2)
tk.Label(root, text="Reference T = 298.15 [K]").grid(row=6, column=0, columnspan=2)
tk.Label(root, text="Reference P = 1e5 [Pa]").grid(row=7, column=0, columnspan=2)

# Create and place the input labels and entries for coefficients and reference values
tk.Label(root, text="Coefficient A (25.46 for oxygen):").grid(row=8, column=0, sticky='e')
entry_A = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_A.grid(row=8, column=1)

tk.Label(root, text="Coefficient B (1.519e-2 for oxygen):").grid(row=9, sticky='e')
entry_B = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_B.grid(row=9, column=1)

tk.Label(root, text="Coefficient C (-7.15e-6 for oxygen):").grid(row=10, sticky='e')
entry_C = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_C.grid(row=10, column=1)

tk.Label(root, text="Coefficient D (1.311e-9 for oxygen):").grid(row=11, column=0, sticky='e')
entry_D = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_D.grid(row=11, column=1)

tk.Label(root, text="Reference T [K]:").grid(row=12, column=0, sticky='e')
entry_T_ref = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_T_ref.grid(row=12, column=1)

tk.Label(root, text="Reference P [Pa]:").grid(row=13, column=0, sticky='e')
entry_P_ref = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_P_ref.grid(row=13, column=1)

tk.Label(root, text="Target T [K]:").grid(row=14, column=0, sticky='e')
entry_T_target = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_T_target.grid(row=14, column=1)

tk.Label(root, text="Target P [Pa]:").grid(row=15, column=0, sticky='e')
entry_P_target = tk.Entry(root, justify='left')  # Change justify to 'left'
entry_P_target.grid(row=15, column=1)

# Create and place the compute button
compute_button = tk.Button(root, text="Compute", command=compute, font=("Calibri", 14))
compute_button.grid(row=16, column=0, columnspan=2, pady=10)

# Create and place the result text boxes for H_IG and S_IG (only numerical values will be displayed)
tk.Label(root, text="H_IG [J/mol]:").grid(row=17, column=0, sticky='e')
result_H_IG_box = tk.Text(root, height=1, width=20)
result_H_IG_box.grid(row=17, column=1)

tk.Label(root, text="S_IG [J/mol/K]:").grid(row=18, column=0, sticky='e')
result_S_IG_box = tk.Text(root, height=1, width=20)
result_S_IG_box.grid(row=18, column=1)

# Create and place a Quit button to close the GUI
quit_button = tk.Button(root, text="Quit", command=quit_app, font=("Calibri", 14), fg="red")
quit_button.grid(row=19, column=0, columnspan=2, pady=10)

# Start the GUI event loop
root.mainloop()
